/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.install.commons.swing.StatusPane;
import oracle.install.commons.util.StatusControl;

public class GraphicalStatusControl
extends StatusControl {
    private JComponent owner;

    public GraphicalStatusControl(JComponent owner) {
        this.owner = owner;
    }

    @Override
    public void close() {
        if (SwingUtilities.isEventDispatchThread()) {
            StatusPane.hideMessage(this.owner);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPane.hideMessage(GraphicalStatusControl.this.owner);
                }
            });
        }
    }

    @Override
    public void open() {
        this.clean();
    }

    @Override
    public void setTimeout(long timeout) {
    }

    @Override
    public void showMessage(final String message) {
        super.showMessage(message);
        if (SwingUtilities.isEventDispatchThread()) {
            StatusPane.showMessage(this.owner, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPane.showMessage(GraphicalStatusControl.this.owner, message);
                }
            });
        }
    }

    @Override
    public void clean() {
        if (SwingUtilities.isEventDispatchThread()) {
            StatusPane.showMessage(this.owner, null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusPane.showMessage(GraphicalStatusControl.this.owner, null);
                }
            });
        }
    }
}

